VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cwHelloWorld"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'A really "basic" Label-Implementation, which may serve as our Entry-Level-Demo here.
'Please look for a more complete Label-implementation in the cwLabel-Class,
'which is the "next in line", if you want to go further down the route to more
'advanced Widgets.

'Also recommended for a first overview on "how things work at all",
'are the comments within ucPanel, which is our gate from memory-rendered,
'windowless and classbased Widgets into the world of "Windows-Messages and hDCs".

Private mCaption As String 'the only internal "Property-Variable" we use here

'The following sequence is required, to write a valid cwXXXXX-Widget!
'It ensures an inheritance-like behaviour for each cwImplementation.
'
'The used: W As WidgetBase (instantiated within Class_Inititalize),
'is comparable to the wellknown type 'UserControl' - which you probably
'know from implementing your own "normal" VB-Controls in VBs *.ctl modules.
'All the Events our 'WithEvents W As cWidgetBase' has to offer, will match
'with those, you often make use of in a VB5/6 Usercontrol-Module (+ something
'more, as MouseWheel, MouseEnter, MouseLeave)...
'
'****---- Start of cwImplementation-Conventions ----****
Private WithEvents W As cWidgetBase
Attribute W.VB_VarHelpID = -1

Private Sub Class_Initialize()
  Set W = New cWidgetBase '<- this Instantiation is then necessary of course in each cwImplementation...
  
  W.CanGetFocus = False '<- and here we override one of the many Default-Properties of W to our needs
  
  'since this simple Widget is also meant, to already demonstrate Unicode-rendering capabilities,
  'these will work properly only, if you choose a font, which contains also the needed "Unicode-Glyphs".
  'On most Win-systems the usual "bread and butter fonts" as e.g. 'Arial', or the newer (Vista+Win7) 'Segoe UI'
  'already support a broad range of Unicode-Glyphs out of the box - so just check, if everything goes
  'well already with the Default-WidgetFont, which is (as said) currently 'Arial' (in size 8.0 BTW).
  '
  'Maybe your language is not rendered correctly with the Default-Font (please check this by
  'proving the small HelloWorld-UTF8-TextContent, this Widget gets feeded with in the Demo-Form).
  'The only language which is not drawn correctly here on my system (XP/SP3) is Korean -
  'all others already seem to come out just fine, with "just plain Arial (and an installed Russian,
  'and Chinese language-pack from my XP-Install-CD".
  'So, please take care, that you choose a matching Font for your language - I'm sure you already
  'better know than myself, which ones work well, and which don't on your given System and locale.
  'As to the Korean example - this one I can get to render correctly as well here, if I choose a
  'Font as shown below - in the outcommented line... ('Arial Unicode MS' usually comes with MS-Office)
  '
'  W.FontName = "Arial Unicode MS"
End Sub

Public Property Get Widget() As cWidgetBase
  Set Widget = W
End Property
Public Property Get Widgets() As cWidgets
  Set Widgets = W.Widgets
End Property
'****---- End of cwImplementation-Conventions ----****


'OK, after we've ensured the above necessities - let's implement our small Hello-World-Widget now,
'starting with its Caption-Property
Public Property Get Caption() As String
  Caption = mCaption
End Property
Public Property Let Caption(ByVal NewValue As String)
  If mCaption = NewValue Then Exit Property
  mCaption = NewValue
  W.Refresh 'a change of the Caption will require a Redraw, so let's signal that over W.Refresh
End Property


'Ok, our Hello-World-Label has got its only Public Property now ...
'...so we can proceed with the remaining Paint-Event and the Drawing-stuff

Private Sub W_Paint(CC As dhCairo.cCairoContext, ByVal xAbs As Single, ByVal yAbs As Single, ByVal DX As Single, ByVal DY As Single, UserObj As Object)
  'here we only delegate to a separate, small Drawing-Procedure -
  'the Parameters of this Paint-Event are described in more detail in the more
  '"fleshed out" cwLabel-Implementation - please look over there, how we deal with
  'them in a "fully cwWidget-conform" Paint-Event Handler-Procedure
  Draw CC
End Sub

Private Sub Draw(CC As cCairoContext)
  'the rectangular Label-BackGround-Fill as well as the Border-Stroke
  CC.SetLineWidth 1
  CC.Rectangle 0, 0, W.Width, W.Height, True '<-- note the last optional Param, which ensures a Pixel-aligned drawing inside the Widgets-Bounds
    If W.BackColor <> -1 Then 'a W.BackColor of -1 would be our indicator for no BackGround-Fill at all...
      CC.SetSourceColor W.BackColor '... so we enter here (ensuring a Fill), only if we got a real BackColor
      CC.Fill True  'as already mentioned a few times in the Cairo-Tutorial-examples, the True-Param ensures waiting for the final Stroke
    End If
    
    CC.SetSourceColor W.BorderColor
  CC.Stroke
  
  'the Text-Output from the contents of mCaption
  CC.SelectFont W.FontName, W.FontSize, W.ForeColor, W.FontBold, W.FontItalic 'the W-Object already contains Default-Font-Descriptions
  CC.DrawText 0, 0, W.ScaleWidth, W.ScaleHeight, mCaption, False, vbCenter, 0, 1 'and the H- and V-Centered Text-Drawing
End Sub

'Congrats, you've just implemented your first simple cwWidget-Control! :-)
